<?php
class Schoolhouse_model extends MY_model {

    public function get($id = null) {

        if (!empty($id)) {

            $query = $this->db->where("id", $id)->get("school_houses");

            return $query->row_array();
        } else {

            $query = $this->db->get("school_houses");
            return $query->result_array();
        }
    }

    public function add($data) {
		$this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        //=======================Code Start===========================
        if (isset($data["id"])) {
            $this->db->where("id", $data["id"])->update("school_houses", $data);
			$message      = UPDATE_RECORD_CONSTANT." On  school houses id ".$data["id"];
			$action       = "Update";
			$record_id    = $data["id"];
			$this->log($message, $record_id, $action);
			//======================Code End==============================
			$this->db->trans_complete(); # Completing transaction
			/*Optional*/
			if ($this->db->trans_status() === false) {
				# Something went wrong.
				$this->db->trans_rollback();
				return false;
			} else {
			//return $return_value;
			}
        } else {
            $this->db->insert("school_houses", $data);
			$id=$this->db->insert_id();
			$message      = INSERT_RECORD_CONSTANT." On school houses id ".$id;
			$action       = "Insert";
			$record_id    = $id;
			$this->log($message, $record_id, $action);
			//======================Code End==============================
			$this->db->trans_complete(); # Completing transaction
			/*Optional*/
			if ($this->db->trans_status() === false) {
				# Something went wrong.
				$this->db->trans_rollback();
				return false;
			} else {
			//return $return_value;
			}
        }
    }

    public function delete($id) {
		$this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        //=======================Code Start===========================
        $this->db->where("id", $id)->delete("school_houses");
		$message      = DELETE_RECORD_CONSTANT." On school houses id ".$id;
        $action       = "Delete";
        $record_id    = $id;
        $this->log($message, $record_id, $action);
		//======================Code End==============================
        $this->db->trans_complete(); # Completing transaction
        /*Optional*/
        if ($this->db->trans_status() === false) {
            # Something went wrong.
            $this->db->trans_rollback();
            return false;
        } else {
        //return $return_value;
        }
    }

}

?>